// normally the model is passed to the view instead of the view creating the model
define([
    'underscore',
    'backbone',
    'marionette',
    'modules/form/section-view',

    'text!modules/new-appointment-request/views/requests/phone-contact/template.html',
    'json!modules/new-appointment-request/views/requests/form.json',
],
function(
    _,
    Backbone,
    Marionette,
    SectionView,
    CommWithClerkSection,
    metadata
) {
    'use strict';

    return SectionView.extend({
        events: {'keyup input': 'validatePhoneAtMaxLength'},
        template: CommWithClerkSection,
        initialize: function(options) {
            var sectionName = 'request-details-phone-contact-section';
            this.legend = this.getLegendFromMetadata(sectionName, metadata, false) || '';
            this.collection = this.getQuestionsFromMetadata(sectionName, metadata);

            // initialize listener to 'change:value' after static values are set
            this.initializeQuestionEventListeners();
        },
        onDomRefresh: function() {
            this.initChildren();
            this.addFormValidationRules();
        },
        // TODO: move to form-view-mixin
        addFormValidationRules: function() {
            this.$el.find('#phoneNumber').rules('add', {
                phoneUS: true,
                messages: {phoneUS: 'Please enter a valid US Phone number.'},
            });

            this.$el.find('#verifyPhoneNumber').rules('add', {
                equalTo: '#phoneNumber',
                messages: {equalTo: 'The phone numbers do not match.'},
            });
        },
        validatePhoneAtMaxLength: function(e) {
            var phoneNumberLength = 14;
            if ($(e.currentTarget).val().length === phoneNumberLength) {
                $(e.currentTarget).valid();
            }
        },
        updateFDNS   el: function(model) {
            var id = model.get('id');
            var val = model.get('value');
            var selected;
            var timesToCall;

            if (id === 'bestTimetoCall') {
                selected = model.get('selected');
                timesToCall = selected ?
                    _.union(this.model.get('bestTimetoCall'), [val]) :
                    _.without(this.model.get('bestTimetoCall'), val);

                this.model.set(id, timesToCall);
            } else {
                this.model.set(id, val);
            }
        },
    });
});
